<?php

/**
 * @author Alan Ryan
 * CodeCrunchers.ie  - alan@codecrunchers.ie
 * Copyright 2010
 */
require_once (INSTALLDIR . 'php' . DIRECTORY_SEPARATOR . 'XMLParser.php');

/**
 * Parse the Data that details the Book
 * @param String FileName $file
 * @return XML Parser Obj
 */
function parse_publication_data($file) {
	
	if (!is_file(DATAFOLDER .  $file))
		return null;

	
	$parser = FALSE;	
	$xml = file_get_contents(DATAFOLDER .  $file);
	if ($xml) {
		$parser = new XMLParser($xml);
		$parser->Parse();

	}
	
	return $parser;
}

/**
 * This should be recursive
 * @param XMLParser Onj
 * @return Array Repr
 */
function build_menu($parserMenu) {

	$menu = $parserMenu->document->tagChildren;
	$_menu = array ();

	for ($j = 0; $j < COUNT($menu); $j++) {
		$_menu[$j] = array ();
		$_menu[$j]['title'] = $menu[$j]->tagAttrs['value048'];
		$L1Menu = $menu[$j]->tagChildren;
		$_menu[$j]['children'] = array ();
		//Bug Fix, Top Level Nodes can  Link 15/02/11 AR
		$_menu[$j]['dest'] = $menu[$j]->tagAttrs['value050'];
		for ($ij = 0; $ij < count($L1Menu); $ij++) {
		
			$_menu[$j]['children'][$ij] = array ();
			$_menu[$j]['children'][$ij]['title'] = $L1Menu[$ij]->tagAttrs['value048'];
			$_menu[$j]['children'][$ij]['dest'] = $L1Menu[$ij]->tagAttrs['value050'];
			$L2Menu = $L1Menu[$ij]->tagChildren;

			if (count($L2Menu)) {
				$_menu[$j]['children'][$ij]['children'] = array ();
				for ($iij = 0; $iij < count($L2Menu); $iij++) {
					$_menu[$j]['children'][$ij]['children'][$iij]['title'] = $L2Menu[$iij]->tagAttrs['value048'];
					$_menu[$j]['children'][$ij]['children'][$iij]['dest'] = $L2Menu[$iij]->tagAttrs['value050'];
				}
			} else {
				//links to?
				$_menu[$j]['children'][$ij]['dest'] = $L1Menu[$ij]->tagAttrs['value050'];
			}
		}
	}
	return $_menu;
}

//TODO: Need to Tidy Up Globals
function load_data_files() {
}
?>