<?php
header("Cache-Control: no-cache"); 
#-------------------------------------------------------------------------
# Project [iPad 3d]
# Version: [iPad 3d]  Alan Ryan www.codecrunchers.ie
# 10:08:53 PM -  Dec 12, 2010

require_once('../config.php');


function parse_search_data(){
	$parserSearch= parse_publication_data('search.xml');
	if(!$parserSearch){
		trigger_error("Search Data Not Parsed",E_USER_ERROR);
	}

	
	return $parserSearch;

}

function do_search($keyword){
	$located = array();
	if(!$keyword) return $located;
	$keyword = trim(strtolower($keyword));
	$parserSearch = parse_search_data();
	

	$arrResults	=	$parserSearch->document->tagChildren;
	/*foreach($arrResults as $paragrah){*/
	for($i=0; $i<COUNT($arrResults); $i++){

		$results		=	$arrResults[$i]->tagAttrs;
		$resultChild	=	"";
		$pageNum		=   $results['pagenumber'];	
		
		foreach($arrResults[$i]->paragraph as $searchInfo){
			
			$resultChild = strtolower($searchInfo->tagData);
		
			if(preg_match('/'.$keyword.'/',$resultChild))
			{
				$aresult = new stdClass();
				$aresult->pageNumber = $pageNum;
				$aresult->snippet = substr($resultChild,0,SNIPPET_SIZE) . "........";
				$located[]=$aresult;
			}
		}
	}
	return $located;
}


function format_results($results,$keyword){
	$strOut="";	
	/*for($i=0; $i<COUNT($results); $i++){
		$strOut.="<li><p><a href=\"javascript:goTo(".$results[$i]->pageNumber.")\">".
			$results[$i]->snippet.
			"</a></p></li>";
	}*/
	$strOut='<div style="float:left;padding:4px;display:block;">'.
	count($results).' Results ';
	if(count($results) > 0) $strOut.='- (Use two fingers to scrolll)</div><br/>';
	$strOut.='<ol style="padding-top:15px;">';
	for($i=0; $i<count($results); $i++){		
		 $strOut.="<li><p><a href=\"javascript:goTo(".$results[$i]->pageNumber.");\">".
			$results[$i]->snippet.
			" (Page: ".$results[$i]->pageNumber.")</a></p><hr style=\"margin-top:10px\" width=\"90%\"/></li>";
	}
	$strOut.='</ol>';	
	
	return $strOut;
}

$located = do_search(isset($_GET['keyword'])?trim($_GET['keyword']):false);//TODO: clean
echo format_results($located,isset($_GET['keyword'])?$_GET['keyword']:"");

?>