/*Copyright Trinity Innovations LTD 2011. All rights reserved*/
/*
# Project [iPad 3D]
# Version: [activeproject_activever]  Alan Ryan www.codecrunchers.ie
#-------------------------------------------------------------------------
*/

var SCROLLROWS = 1;
var tocScroll,searchScroll;
var thumbPath = "../thumbs/";
if(_3DGENERATORVERSION > 3){
thumbPath = "../pages/thumbs/";
}

/** carousel callbacks * */

/**
 * Called when we look for more thumnail images
 */
function thumbCarousel_itemLoadCallback(carousel, state)
{
	// Since we get all URLs in one file, we simply add all items
    // at once and set the size accordingly.
	firstImageToLoad = -1;	
	scrollImagesCount = SCROLLROWS * COLSINTHUMBROW; 
	
    if (state == 'init' || state == 'prev')
        return -1;

    // spinner start
   if(state=='next'){
	   firstImageToLoad = (carousel.first * COLSINTHUMBROW) + 1;

	   newThumbs = new Array();
	   var imgIndex = 0;
	   for($imgCount = firstImageToLoad; $imgCount <= totalPageCount /* extern */&& imgIndex++ < scrollImagesCount ; $imgCount++)
		   newThumbs.push(thumbPath+$imgCount+'.jpg');
   }
      
   if(consoleLog){
		console.log("Thumbs To Be Loaded:" + newThumbs);
		console.log("Carousel First" + carousel.first, "Last " + carousel.last);		
   }
   
   
   // start spinner
   $('#cparea').append($('#cpLoader').show());
   
   $.imgpreload( newThumbs, 
		   function() { _thumbsLoaded(carousel,newThumbs, state); }  
   );
   
   window.setTimeout(function(){$('#cpLoader').hide();},500); 
   
   
};

/**
 * Called after images are loaded from server
 * 
 * @param carousel
 * @param data
 * @return
 */
function _thumbsLoaded(carousel,data,state){	

	 thumbCarousel_itemAddCallback(carousel, carousel.first, carousel.last, data, state);
}

/**
 * 
 * @param carousel
 *            Scrollable Windows
 * @param first
 *            First Row Visible
 * @param last
 *            Last Row Visible
 * @param data
 *            images to load
 * @param state
 *            forward/back
 * @return
 */
function thumbCarousel_itemAddCallback(carousel, first, last, data, state){
	
	newRow = "";
	counter = 0;
	$(data).each(function(i,value) {
		counter++;
		if(state=='next'){ 
			newRow=newRow + ' ' + thumbCarousel_getItemHTML(value,( (first*COLSINTHUMBROW)+i)+1);
		}else{
			return;
		}
		
		//if(counter%COLSINTHUMBROW == 0){
		if(counter == data.length){
			if(state=='next'){				
				carousel.add(first + 1, '<li>'+newRow+'</li>');
				if(consoleLog)						
					console.log("Add to Row " + (first + (counter/COLSINTHUMBROW)) + ":" + newRow );
			}		
			newRow = "";
		}
		
    });	
}

/**
 * Item html creation helper.
 */
function thumbCarousel_getItemHTML(url,imgIndex)
{		
    return '<img height="'+THUMBHEIGHT+'" width=="'+THUMBWIDTH+'" onClick="goTo('+(imgIndex)+');activateMap();" id="t' +imgIndex+ '" class="thumbimg" src="' + url + '" />';
}


$(document).ready(function(){
	
$('#cpTitleBar .close').click(function(event){
		
		$('#cparea').animate({			    
			 height: "0px",
			 opacity: 0.4,			    
			  }, 500, 
			  function() {
				  $('#cparea').hide();
				  thumbNavUp=!thumbNavUp;				  
			  });
	});

	$('.cpitem').click(function(event){
		// console.log (event.attr('id'));
		control = $(this);		
		if(!thumbNavUp){			
		 $('#cparea').animate({			    			    
			 height: "325px",
			 opacity: 1.0,
			  }, 500, 
			  function() {				  
				  thumbNavUp=!thumbNavUp;
				  load_control_panel_container(control);
				  $('#cparea').show();
			  });
		}else{
			// Close if user select the same icon
			if(activeCPControl == control.attr('id')){
			 $('#cparea').animate({			    
				 height: "0px",
				 opacity: 0.4,			    
				  }, 500, 
				  function() {
					  $('#cparea').hide();
					  thumbNavUp=!thumbNavUp;				  
				  });
			}else{
				load_control_panel_container(control);
			}
		}		
	});
			
	
	/** Thumbnail carousel * */
	jc = $('#IIIDcarousel').jcarousel({
		itemLoadCallback: thumbCarousel_itemLoadCallback,		
        scroll: SCROLLROWS,
        size: Math.floor(Number((totalPageCount  / COLSINTHUMBROW ) + 1)),
        vertical: true,
    });	
	
});


/** Control Panel * */	
function load_control_panel_container(control){
	
	activeCPControl = control.attr('id');
	
	switch(control.attr('id')){
	case "toc":
		$('#cparea').append($('#tocnav').show());
		$('#thumbnailnav').hide();
		$('#searchnav').hide();
		$('#cpTitleBar .title').text(TEXT_CONTENTS);		
		break;
	case "ttoc":
		$('#cparea').append($('#thumbnailnav').show());
		$('#tocnav').hide();
		$('#searchnav').hide();
		$('#cpTitleBar .title').text(TEXT_THUMBNAILS);
		break;
	case "cpsearch":
		$('#cparea').append($('#searchnav').show());
		$('#tocnav').hide();
		$('#thumbnailnav').hide();
		$('#cpTitleBar .title').text(TEXT_SEARCH);
	}
}


